<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Allow-Headers: Content-Type");

require_once 'config.php';  // Database configuration file

$conn = getDbConnection();

// Get search term from the query string
$searchTerm = isset($_GET['search']) ? $_GET['search'] : '';

$sql = "SELECT user_id, real_name, username FROM users WHERE real_name LIKE ?";
$stmt = $conn->prepare($sql);
$searchTerm = "%{$searchTerm}%";
$stmt->bind_param("s", $searchTerm);
$stmt->execute();

$result = $stmt->get_result();
$users = [];

while ($row = $result->fetch_assoc()) {
    $users[] = $row;
}

echo json_encode($users);
$stmt->close();
$conn->close();

