<?php
require 'config.php';

$conn = getDbConnection();

$query = "SELECT clock_in.id, users.real_name AS userName, sites.site_name AS siteName, 
                 clock_in.clock_in_tag, clock_in.clock_in_time 
          FROM clock_in 
          JOIN users ON clock_in.user_id = users.user_id 
          JOIN sites ON clock_in.site_id = sites.site_id 
          ORDER BY clock_in.clock_in_time DESC";

$result = $conn->query($query);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Clock In Records</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-4">
        <h2>Clock In Records</h2>
        <table class="table table-bordered">
            <thead class="table-dark">
                <tr>
                    <th>User</th>
                    <th>Site</th>
                    <th>Tag</th>
                    <th>Time</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?= $row['userName'] ?></td>
                    <td><?= $row['siteName'] ?></td>
                    <td><?= $row['clock_in_tag'] ?></td>
                    <td><?= $row['clock_in_time'] ?></td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
