<?php
require 'config.php'; // Include the database connection file

header("Content-Type: application/json");

// Call the function to establish a database connection
$conn = getDbConnection();

$data = json_decode(file_get_contents("php://input"), true);

if (isset($data['token'], $data['site_id'], $data['personal_safety'], $data['site_secure'], $data['equipment_functional'])) {
    $token = $data['token'];
    $site_id = $data['site_id'];
    $personal_safety = $data['personal_safety'];
    $site_secure = $data['site_secure'];
    $equipment_functional = $data['equipment_functional'];
    $comments = isset($data['comments']) ? $data['comments'] : null;

    // Prepare and bind
    $stmt = $conn->prepare("INSERT INTO hourly_check (token, site_id, personal_safety, site_secure, equipment_functional, comments) 
                            VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("siisss", $token, $site_id, $personal_safety, $site_secure, $equipment_functional, $comments);

    if ($stmt->execute()) {
        http_response_code(200);
        echo json_encode(["message" => "Hourly Check Submitted Successfully"]);
    } else {
        http_response_code(500);
        echo json_encode(["message" => "Failed to submit hourly check"]);
    }

    $stmt->close();
    $conn->close();
} else {
    http_response_code(400);
    echo json_encode(["message" => "Invalid input"]);
}
?>

