<?php
require __DIR__ . '/config.php';

header('Content-Type: application/json');

$conn = getDbConnection();

// ✅ Ensure `site_id` is provided
if (!isset($_GET['site_id']) || empty($_GET['site_id'])) {
    echo json_encode(["success" => false, "message" => "Missing site_id", "tags" => []]);
    exit;
}

$site_id = intval($_GET['site_id']);
$query = "SELECT tag_id, tag_name, site_id, tag_type, latitude, longitude, is_active FROM nfc_tags WHERE site_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $site_id);
$stmt->execute();
$result = $stmt->get_result();

$tags = [];
while ($row = $result->fetch_assoc()) {
    $row['is_active'] = ($row['is_active'] == 1); // ✅ Convert `0/1` to `true/false`
    $tags[] = $row;
}

// ✅ Return success message with `tag_name`
echo json_encode(["success" => true, "message" => "Tags retrieved successfully", "tags" => $tags]);

$conn->close();
?>
