<?php
require 'db_config.php';

if (isset($_GET['site_id'])) {
    $site_id = intval($_GET['site_id']);
    $stmt = $conn->prepare("SELECT * FROM tags WHERE site_id = ?");
    $stmt->bind_param("i", $site_id);
    $stmt->execute();
    
    $result = $stmt->get_result();
    $tags = [];
    while ($row = $result->fetch_assoc()) {
        $tags[] = $row;
    }
    
    echo json_encode(["success" => true, "tags" => $tags]);
    $stmt->close();
} else {
    echo json_encode(["success" => false, "message" => "Missing site_id"]);
}
$conn->close();
?>

