<?php
require 'db_config.php';

if (isset($_GET['site_id'])) {
    $site_id = intval($_GET['site_id']);
    $stmt = $conn->prepare("
        SELECT t.id, t.name, t.type, t.latitude, t.longitude 
        FROM patrol_routes pr 
        JOIN tags t ON pr.tag_id = t.id 
        WHERE pr.site_id = ? 
        ORDER BY pr.order_position
    ");
    $stmt->bind_param("i", $site_id);
    $stmt->execute();
    
    $result = $stmt->get_result();
    $route = [];
    while ($row = $result->fetch_assoc()) {
        $route[] = $row;
    }
    
    echo json_encode(["success" => true, "route" => $route]);
    $stmt->close();
} else {
    echo json_encode(["success" => false, "message" => "Missing site_id"]);
}
$conn->close();
?>

