<?php
require __DIR__ . '/config.php';

header('Content-Type: application/json');

$conn = getDbConnection();
$data = json_decode(file_get_contents("php://input"), true);

if (isset($data['tag_ids'])) {
    $tag_ids = implode(',', array_map('intval', $data['tag_ids']));

    // Activate NFC tags in batch
    $query = "UPDATE nfc_tags SET is_active = TRUE WHERE tag_id IN ($tag_ids)";
    if ($conn->query($query)) {
        echo json_encode(["success" => true, "message" => "Tags activated"]);
    } else {
        echo json_encode(["success" => false, "message" => $conn->error]);
    }
} else {
    echo json_encode(["success" => false, "message" => "No tag IDs provided"]);
}

$conn->close();
?>
